/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;

public class EntityMeltingModule {
    public static final DamageSource SMELTERY_DAMAGE = new DamageSource(TConstruct.prefix("smeltery_heat")).m_19383_();
    public static final DamageSource SMELTERY_MAGIC = new DamageSource(TConstruct.prefix("smeltery_magic")).m_19389_();
    private final MantleBlockEntity parent;
    private final IFluidHandler tank;
    private final BooleanSupplier canMeltEntities;
    private final Function<ItemStack, ItemStack> insertFunction;
    private final Supplier<AABB> bounds;
    @Nullable
    private EntityMeltingRecipe lastRecipe;

    private Level getLevel() {
        return Objects.requireNonNull(this.parent.m_58904_(), "Parent tile entity has null world");
    }

    @Nullable
    private EntityMeltingRecipe findRecipe(EntityType<?> type) {
        if (this.lastRecipe != null && this.lastRecipe.matches(type)) {
            return this.lastRecipe;
        }
        EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(this.getLevel().m_7465_(), type);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public static FluidStack getDefaultFluid() {
        return new FluidStack((Fluid)TinkerFluids.blood.get(), 50);
    }

    private boolean canMeltEntity(LivingEntity entity) {
        return !entity.m_6673_(entity.m_5825_() ? SMELTERY_MAGIC : SMELTERY_DAMAGE) && (!(entity instanceof Player) || !((Player)entity).m_150110_().f_35934_) && !entity.m_21023_(MobEffects.f_19607_);
    }

    public boolean interactWithEntities() {
        AABB boundingBox = this.bounds.get();
        if (boundingBox == null) {
            return false;
        }
        Boolean canMelt = null;
        boolean melted = false;
        for (Entity entity : this.getLevel().m_45976_(Entity.class, boundingBox)) {
            int damage;
            FluidStack fluid;
            if (!entity.m_6084_()) continue;
            EntityType type = entity.m_6095_();
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack stack = this.insertFunction.apply(itemEntity.m_32055_());
                if (stack.m_41619_()) {
                    entity.m_146870_();
                    continue;
                }
                itemEntity.m_32045_(stack);
                continue;
            }
            if (canMelt == Boolean.FALSE || type.m_204039_(TinkerTags.EntityTypes.MELTING_HIDE) || !(entity instanceof LivingEntity) || !this.canMeltEntity((LivingEntity)entity)) continue;
            if (canMelt == null) {
                canMelt = this.canMeltEntities.getAsBoolean();
            }
            if (!canMelt.booleanValue()) continue;
            EntityMeltingRecipe recipe = this.findRecipe(entity.m_6095_());
            if (recipe != null) {
                fluid = recipe.getOutput((LivingEntity)entity);
                damage = recipe.getDamage();
            } else {
                fluid = EntityMeltingModule.getDefaultFluid();
                damage = 2;
            }
            if (!entity.m_6469_(entity.m_5825_() ? SMELTERY_MAGIC : SMELTERY_DAMAGE, (float)damage)) continue;
            this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            melted = true;
        }
        return melted;
    }

    public EntityMeltingModule(MantleBlockEntity parent, IFluidHandler tank, BooleanSupplier canMeltEntities, Function<ItemStack, ItemStack> insertFunction, Supplier<AABB> bounds) {
        this.parent = parent;
        this.tank = tank;
        this.canMeltEntities = canMeltEntities;
        this.insertFunction = insertFunction;
        this.bounds = bounds;
    }
}

